class MW_PRI extends PlayerReplicationInfo;

//Replicated variables:
var int		DamageDone;			// holds info about how much damage the player has caused (used to calculate level)
var int		Level;				// holds info about what level the player has.
var int		Money;				// holds the info about the current ammount of money
var int		StatPoints;			// holds the number of available statpoints
var int		SkillPoints;		// holds the numbers of available skillponts			
var float	PCTNextLevel;		// holds the info about the players % towards next level, used to draw progress bar on HUD

//UnReplicated Variables:
var int		ScoreStep;			// holds the value of the BaseScore (When to reach next level)
var float 	NextLevel, ProgressNextLevel, Distance, ScoreStart;

replication
{
	// Things the server should send to the client.
	reliable if (Role == ROLE_Authority)
		DamageDone,Level,Money,StatPoints,SkillPoints,PCTNextLevel;
}

function PostBeginPlay()
{
	Timer();
	SetTimer(1.0, true);
	bIsFemale = Pawn(Owner).bIsFemale;
}

function Timer()
{
	Super.Timer();
	
	CheckLevel();
}

function CheckLevel()
{
	ScoreStart = ( Level - 1 ) * ScoreStep * ( Level - 1 );
	NextLevel = Level * ScoreStep * Level;
	
	Distance = NextLevel - ScoreStart;
	ProgressNextLevel = Distance - ( DamageDone - ScoreStart );
	PCTNextLevel = 1 - ProgressNextLevel / Distance;
	
	if ( PCTNextLevel < 0 )
		PCTNextLevel = 0;
	else if ( PCTNextLevel > 1 )
		PCTNextLevel = 1;
	
	if ( DamageDone >= NextLevel )
		{
		Level += 1;
		PlayerPawn(Owner).ReceiveLocalizedMessage( class'LevelUpMessage' );
		StatPoints += 5;
		SkillPoints += 1;
		}
}

defaultproperties
{
Level=1
Money=0
StatPoints=0
ScoreStep=100
PCTNextLevel=0
}
